add_portrait("Replicant Commander Theresia", "replicant_commander.png", 1);
add_portrait("Admiral Vadas", "admiral_vadas.png", 0);
add_portrait("Moravator Captain", "captain.png", 0);
add_portrait("Tutorial", "tutorial_portrait.png", 0);
add_portrait("Artilian Bomber Pilot", "dont_move.png", 2);

cut_scene_on();
wait(30);

set_portrait("Replicant Commander Theresia");
portrait_text("Admiral Vadas! At last! It seems as though every ship in the Artilian fleet is chasing me.", "admiral_vadas.ogg");
wait_for_portrait();

set_portrait("Admiral Vadas");
portrait_text("Commander Theresia! We'll do everything we can to ensure your safe passage into Morellian space. We should reach one of our automated defence nets in a couple of minutes, we only have to hold out until then.", "commander.ogg");
wait_for_portrait();

set_portrait("Moravator Captain");
portrait_text("Do not worry, Commander. This fleet is brimming with immense firepower - you're safe now!", "do_not_worry.ogg");
wait_for_portrait();

pause_world();
set_portrait("Tutorial");
portrait_text("Your capital ships and frigates are indeed brimming with weapons, which they will automatically fire at any enemies within range. You can also manually order yours ships to attack enemy capital ships and frigates, should you so wish.", "your_capital.ogg");
wait_for_portrait();
unpause_world();

set_portrait("Replicant Commander Theresia");
portrait_text("Despite all your immense weaponry, you can only fire at so many targets at once. You must already know that just a single well planned torpedo bomber attack could wipe out your entire fleet.", "despite_all.ogg");
wait_for_portrait();

set_portrait("Admiral Vadas");
portrait_text("All too true, Commander. All ships, launch fighters and do everything you can to defend Commander Theresia until she reaches our defensive net.", "all_too_true.ogg");
wait_for_portrait();

pause_world();
set_portrait("Tutorial");
portrait_text("Use the missions menu to launch fighters on combat patrols. Ships ordered to patrol will perfom a continuous loop around their waypoints until they run out of fuel, and will automatically attack any enemies they come across.", "use_the.ogg");
wait_for_portrait();

portrait_text("Do not attempt to launch your torpedo bombers on this mission, you do not want to provoke the Artilians into launching all of their fighters at once.", "use_the.ogg");
wait_for_portrait();

foreach(squad in my_squads) {
	type = squad.get_type();
	if (type == 2 || type == 3)
		squad.select();
}
order_move(2741, 37042);

unpause_world();
cut_scene_off();

while (true) {
	wait(-1);
	local wakeup_reason = wakeup_reason();
	
	if (wakeup_reason == "custom_ai_task_0") {
		set_portrait("Artilian Bomber Pilot");
		portrait_text("This is squadron Gamma-5, we've caught up with the defector! All ships, attack! Die, traitor!", "this_is.ogg");
		wait_for_portrait();

		set_portrait("Replicant Commander Theresia");
		portrait_text("Destroy these imbeciles!", "destroy_these.ogg");
	} else if (wakeup_reason == "custom_ai_task_1")
		break;
	else if (which_side_dead() == 1)
		player_failed_mission("Defector was killed");
}
mission_complete();

set_portrait("Moravator Captain");
portrait_text("We've made it! There's the defensive net!", "weve_made.ogg");
wait_for_portrait();

set_portrait("Replicant Commander Theresia");
portrait_text("Thank you for your protection, Admiral. It would have been disastrous for your superiors had I been killed. I am sorry for your losses, but the information I can give them is worth a million of your men.", "thank_you.ogg");
wait_for_portrait();

wait(150);
end_mission();
